uniform sampler2D t1;
uniform sampler2D depthpacked;

uniform float start;
uniform float end;
uniform float red;
uniform float green;
uniform float blue;

float unpackFloatFromVec3i(const vec3 value)
{
   const vec3 bitSh = vec3( 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
   return(dot(value, bitSh));
}

float getdepth(vec2 xy)
{
   float depth;
   vec3 col=texture2D(depthpacked,xy).xyz;
   if(col.x==0.0 && col.y==0.0 && col.z==0.0)
   depth=1000000000.0;   
   else   
   depth=unpackFloatFromVec3i(col);
   return depth;
}

void main()
{
		float temp;
		int inv=0;
		vec2 uv = gl_TexCoord[0].xy;
		float d = (getdepth(uv))*100/end  -start;
		if(start<end)
		{
			temp=end;
			end=start;
			start=temp;
			inv=1;
		}
		if(d>1)
			d=1;
		if(d<0)
			d=0;
		
		if(inv=0)
			d=1-d;

		vec4 c2 = vec4(red,green,blue,1)*d;
		vec4 c = c2+texture2D(t1,uv)*(1-d);
		//c=c*c2;
		gl_FragColor = c;
}
